<?php
include __DIR__ . '/componentes/alertas.php';
// Este archivo define funciones PHP que inyectan funciones JS para alertas SweetAlert2

// Inyectamos SweetAlert2 solo una vez
echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';

function alertaExito($mensaje) {
    echo <<<HTML
    <script>
        function alertaExitoJS() {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: '$mensaje',
                confirmButtonText: 'Aceptar'
            });
        }
    </script>
HTML;
}

function alertaError($mensaje) {
    echo <<<HTML
    <script>
        function alertaErrorJS() {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: '$mensaje',
                confirmButtonText: 'Aceptar'
            });
        }
    </script>
HTML;
}

function alertaInfo($mensaje) {
    echo <<<HTML
    <script>
        function alertaInfoJS() {
            Swal.fire({
                icon: 'info',
                title: 'Información',
                text: '$mensaje',
                confirmButtonText: 'Entendido'
            });
        }
    </script>
HTML;
}
?>
