function disableWordButton(originalIndex, word, disable) {
  const container = document.getElementById('exercise');
  const cards = container.querySelectorAll('.card');

  // Buscar la tarjeta que corresponde al originalIndex
  const card = Array.from(cards).find(card => {
    const img = card.querySelector('img');
    return img && img.src.includes(`img${originalIndex + 1}.jpg`);
  });

  if (!card) return;

  const allButtons = Array.from(card.querySelectorAll('.word-btn'));

  const wordCount = blanks[originalIndex].words.filter(w => w === word).length;
  const usedCount = (userAnswers[originalIndex] || []).filter(w => w !== null && w === word).length;

  allButtons.forEach(btn => {
    if (btn.textContent.trim() === word) {
      const shouldDisable = usedCount >= wordCount;
      btn.disabled = shouldDisable;
      btn.classList.toggle('disabled', shouldDisable);
    }
  });
}
