  function mostrarPista(lineIdx) {

  const palabras = blanks[lineIdx].words;

  const total = palabras.length;

  const cantidad = Math.ceil(total / 2);



  const disponibles = [];

  for (let i = 0; i < total; i++) {

    if (!userAnswers[lineIdx] || !userAnswers[lineIdx][i]) {

      disponibles.push(i);

    }

  }



  // Mezclar disponibles

  for (let i = disponibles.length - 1; i > 0; i--) {

    const j = Math.floor(Math.random() * (i + 1));

    [disponibles[i], disponibles[j]] = [disponibles[j], disponibles[i]];

  }



  const seleccionadas = [];



  for (let idx of disponibles) {

    const esConsecutiva = seleccionadas.some(sel => Math.abs(sel - idx) === 1);

    if (!esConsecutiva) {

      seleccionadas.push(idx);

      if (seleccionadas.length >= cantidad) break;

    }

  }



  if (seleccionadas.length < cantidad) {

    for (let idx of disponibles) {

      if (!seleccionadas.includes(idx)) {

        seleccionadas.push(idx);

        if (seleccionadas.length >= cantidad) break;

      }

    }

  }



  const slots = document.querySelectorAll(`.word-slot[data-line="${lineIdx}"]`);

  if (!userAnswers[lineIdx]) userAnswers[lineIdx] = [];



  seleccionadas.forEach(i => {

    userAnswers[lineIdx][i] = palabras[i];

    slots[i].textContent = palabras[i];

    slots[i].classList.remove('empty');

    slots[i].classList.add('filled');

    disableWordButton(lineIdx, palabras[i], true);

  });



  const feedbackEl = document.getElementById(`feedback-${lineIdx}`);

  // feedbackEl.innerHTML = `<span class="text-warning">💡 Se colocaron ${seleccionadas.length} palabra(s) como pista</span>`;

  feedbackEl.innerHTML = ''; // Limpiamos el feedback para que no muestre nada

  feedbackEl.classList.remove('correct', 'incorrect');

}

