function renderExercise() {
  const container = document.getElementById('exercise');
  container.innerHTML = '';

  const paired = blanks.map((blank, i) => ({
    words: blank.words,
    text: textLines[i],
    originalIndex: i
  }));

  const shuffledPaired = shuffle([...paired]);

  shuffledPaired.forEach(({ words, text, originalIndex }, idx) => {
    const phraseSlots = words.map((_, i) => {
      return `<span class="word-slot empty" data-line="${idx}" data-slot="${i}" onclick="removeWord(${idx}, ${i})">___</span>`;
    });

    const shuffledWords = shuffle(words);

    const buttonsHtml = shuffledWords.map(w =>
      `<button class="btn btn-outline-primary word-btn" onclick="addWord(${idx}, '${w}'); pronunciar('${w}')">${w}</button>
      
      `
    ).join(' ');

    const cardHtml = `
      <div class="card mb-4 shadow">
        <img src="img/img${originalIndex + 1}.jpg" class="card-img-top" alt="Imagen ${originalIndex + 1}" onerror="this.style.display='none'">
        <div class="tituloCard text-center" style="display: none;">
          <p class="mb-1 text-center"><em>${text.es}</em></p>
        </div>
        <div class="tituloPregunta text-center" onclick="mostrarTitulo(${idx}); pronunciarFraseCompletaTexto('${text.en}')">
          <h1 class="signoPregunta" > ?</h1>
        </div>
        <div class="d-flex justify-content-center">${phraseSlots.join(' ')}</div>
        <div class="text-center">
          <span id="feedback-${idx}"></span>
          <div class="d-flex flex-wrap justify-content-center mt-2">${buttonsHtml}</div>
        </div>
        <div class="text-center p-2">
          <button class="btn btn-secondary btn-sm me-2" onclick="mostrarPista(${idx})">Pista</button>
          <button class="btn btn-secondary btn-sm" onclick="limpiarFrase(${idx})">Limpiar</button>
        </div>
      </div>
    `;

    container.insertAdjacentHTML('beforeend', cardHtml);
  });
}
