console.log('interaction.js cargado');

function addWord(lineIdx, word) {
  if (!userAnswers[lineIdx]) {
    userAnswers[lineIdx] = Array(blanks[lineIdx].words.length).fill(null);
  }
  
  const firstEmptyIndex = userAnswers[lineIdx].indexOf(null);
  if (firstEmptyIndex !== -1) {
    userAnswers[lineIdx][firstEmptyIndex] = word;
    
    const isComplete = userAnswers[lineIdx].every(w => w !== null);
    if (isComplete) {
      const isCorrect = blanks[lineIdx].words.every((w, i) => w === userAnswers[lineIdx][i]);
      if (isCorrect) {
        utils.saveProgress();
        setTimeout(() => {
          if (currentCardIndex < blanks.length - 1) {
            currentCardIndex++;
            renderExercise();
          }
        }, 1000);
      }
    }
  }
}

function showTranslation(button, word, lineIndex) {
  addWord(lineIndex, word);

  const translation = getTranslation(word, lineIndex);

  // 👉 Mostrar traducción dentro del card actual
  const cardMeaning = document.getElementById('card-meaning');
  if (cardMeaning) {
    cardMeaning.innerHTML = `
      <h1>${word} <span class="badge bg-secondary">${translation}</span></h1>
    `;

    // Ocultar después de 3 segundos
    setTimeout(() => {
      cardMeaning.innerHTML = '';
    }, 3000);
  }

  // Validar si la frase se completó correctamente
  const isComplete = userAnswers[lineIndex]?.every(w => w !== null);
  const isCorrect = isComplete && blanks[lineIndex].words.every((w, i) => w === userAnswers[lineIndex][i]);

  if (isCorrect) {
    utils.saveProgress();
    setTimeout(() => {
      if (currentCardIndex < blanks.length - 1) {
        currentCardIndex++;
      }
      renderExercise();
    }, 1000);
  }
}




function removeWord(lineIdx, slotIdx) {
  if (userAnswers[lineIdx] && userAnswers[lineIdx][slotIdx] !== null) {
    userAnswers[lineIdx][slotIdx] = null;
    renderExercise();
  }
}

function mostrarPista(lineIdx) {
  const nextWord = blanks[lineIdx].words.find((word, i) => 
    !userAnswers[lineIdx] || userAnswers[lineIdx][i] === null
  );
  if (nextWord) {
    alert(`La siguiente palabra es: "${nextWord}"`);
  } else {
    alert("¡Ya has completado todas las palabras!");
  }
}

function limpiarFrase(lineIdx) {
  userAnswers[lineIdx] = Array(blanks[lineIdx].words.length).fill(null);
  renderExercise();
}

function mostrarAnterior() {
  if (currentCardIndex > 0) {
    currentCardIndex--;
    renderExercise();
  }
}

function mostrarSiguiente() {
  if (currentCardIndex < blanks.length - 1) {
    currentCardIndex++;
    renderExercise();
  }
}

window.addWord = addWord;
window.showTranslation = showTranslation;
window.removeWord = removeWord;
window.mostrarPista = mostrarPista;
window.limpiarFrase = limpiarFrase;
window.mostrarAnterior = mostrarAnterior;
window.mostrarSiguiente = mostrarSiguiente;