function renderExercise() {
  const container = document.getElementById('exercise');
  container.innerHTML = '';

  const { words } = blanks[currentCardIndex];
  const currentAnswer = userAnswers[currentCardIndex] || Array(words.length).fill(null);
  const imgNumber = currentCardIndex + 1;
  const imgPath = imgNumber === 1 ? 'img/img.jpg' : `img/img${imgNumber}.jpg`;
  const isCardCompleted = utils.checkCardCompletion(currentCardIndex);

  const isComplete = currentAnswer.every(word => word !== null);
  const isCorrect = isComplete && words.every((word, i) => word === currentAnswer[i]);

  let feedback = '';
  if (isCardCompleted) {
    feedback = '<div class="feedback-completed">✓ Completado anteriormente</div>';
  } else if (isComplete) {
    feedback = isCorrect 
      ? '<div class="feedback-correct">✓ ¡Correcto!</div>' 
      : '<div class="feedback-incorrect">✗ Inténtalo de nuevo</div>';
  }

  const phraseSlots = words.map((_, i) => {
    const word = currentAnswer[i];
    return word 
      ? `<span class="word-slot filled" onclick="removeWord(${currentCardIndex}, ${i})">${word}</span>`
      : `<span class="word-slot empty">___</span>`;
  });

  const buttonsHtml = utils.shuffle([...words]).map(word => {
    const isUsed = currentAnswer.includes(word);
    const translation = getTranslation(word, currentCardIndex);
    return `
      <button class="word-btn ${isUsed ? 'used' : ''}" 
              onclick="showTranslation(this, '${word}', ${currentCardIndex})"
              ${isUsed ? 'disabled' : ''}>
        ${word}
        <div class="word-translation" style="display: none;">${translation}</div>
      </button>`;
  }).join('');

  const cardHtml = `
    <div class="exercise-card ${isCardCompleted ? 'completed-card' : ''}">
      <div class="image-container">
        <img src="${imgPath}" alt="${textLines[currentCardIndex].es}" class="exercise-image" 
             onerror="this.style.display='none'">
        ${isCardCompleted ? '<span class="completed-badge">Completado</span>' : ''}
      </div>
      
      <div class="exercise-content">
        <p class="sentence-hint">${textLines[currentCardIndex].es}</p>
        
        <div class="word-slots">${phraseSlots.join('')}</div>
        
        ${feedback}
        
        <div id="card-meaning" class="text-center mb-3"></div>
        
        <div class="word-buttons">${buttonsHtml}</div>
        
        <div class="action-buttons">
          <button class="action-btn hint-btn" onclick="mostrarPista(${currentCardIndex})">
            <i class="bi bi-lightbulb"></i> Mostrar pista
          </button>
          <button class="action-btn clear-btn" onclick="limpiarFrase(${currentCardIndex})">
            <i class="bi bi-eraser"></i> Limpiar
          </button>
        </div>
      </div>
      
      <div class="navigation">
        <button class="nav-btn prev-btn" onclick="mostrarAnterior()" 
                ${currentCardIndex === 0 ? 'disabled' : ''}>
          <i class="bi bi-chevron-left"></i> Anterior
        </button>
        <span class="progress-indicator">${imgNumber}/${blanks.length}</span>
        <button class="nav-btn next-btn" onclick="mostrarSiguiente()" 
                ${currentCardIndex === blanks.length - 1 ? 'disabled' : ''}>
          Siguiente <i class="bi bi-chevron-right"></i>
        </button>
      </div>
    </div>`;

  container.innerHTML = cardHtml;
  utils.updateProgressHeader();
}

window.renderExercise = renderExercise;



function getTranslation(word, lineIndex) {
  if (contextualTranslations[lineIndex]?.[word]) {
    return contextualTranslations[lineIndex][word];
  }
  
  for (const translations of contextualTranslations) {
    if (translations[word]) {
      return translations[word];
    }
  }
  
  return word;
}

window.renderExercise = renderExercise;
window.getTranslation = getTranslation;