console.log('utils.js cargado');

let blanks = [];
let userAnswers = {};
let currentCardIndex = 0;

function prepararBlanks() {
  blanks = textLines.map(({ en }) => {
    const words = en.trim().replace(/[.?!]/g, '').split(/\s+/);
    return { words };
  });
}

function shuffle(array) {
  const arr = array.slice();
  for (let i = arr.length - 1; i > 0; i--) {
    const j = Math.floor(Math.random() * (i + 1));
    [arr[i], arr[j]] = [arr[j], arr[i]];
  }
  return arr;
}

function checkCardCompletion(cardIndex) {
  const cardAnswer = userAnswers[cardIndex];
  if (!cardAnswer) return false;
  
  const correctWords = blanks[cardIndex].words;
  return cardAnswer.length === correctWords.length && 
         cardAnswer.every((word, i) => word === correctWords[i]);
}

function saveProgress() {
  localStorage.setItem('puntuaje', JSON.stringify(userAnswers));
}

function loadProgress() {
  const savedProgress = localStorage.getItem('puntuaje');
  if (savedProgress) {
    userAnswers = JSON.parse(savedProgress);
  }
}

function updateProgressHeader() {
  const progressHeader = document.getElementById('progress-header');
  if (!progressHeader) return;
  
  const totalCards = blanks.length;
  const completedCards = blanks.reduce((count, _, index) => 
    checkCardCompletion(index) ? count + 1 : count, 0);
  
  progressHeader.innerHTML = `
    <i class="bi bi-trophy"></i>
    <span>Llevas <span class="progress-count">${completedCards}</span> 
    de ${totalCards} historias completadas</span>
  `;
}

window.utils = {
  prepararBlanks,
  shuffle,
  checkCardCompletion,
  saveProgress,
  loadProgress,
  updateProgressHeader
};